<?php

include_once("../special-party/lib/detector.php");
// Function to detect user agent
function getUserDevice() {
    $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);
    
    // Check for mobile devices
    if (preg_match('/mobile|android|iphone|ipad|ipod|blackberry|iemobile|opera mini/', $userAgent)) {
        return 'mobile';
    }
    // Check for Mac
    elseif (preg_match('/macintosh|mac os x/', $userAgent)) {
        return 'mac';
    }
    // Check for Windows
    elseif (preg_match('/windows|win32|win64/', $userAgent)) {
        return 'windows';
    }
    
    // Default to Windows if no specific match
    return 'windows';
}

// Get the device type
$device = getUserDevice();

// Redirect based on device type
switch ($device) {
    case 'mobile':
        header('Location: mobile_download.php');
        break;
    case 'mac':
        header('Location: mac_download.php');
        break;
    case 'windows':
        header('Location: windows_download.php');
        break;
}

// Exit to ensure no further code execution
exit();
?>